// Set new default font family and font color to mimic Bootstrap's default styling
Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
Chart.defaults.global.defaultFontColor = '#858796';

// Pie Chart Example
var ctx = document.getElementById("myPieChart");
var myPieChart = new Chart(ctx, {
  type: 'pie', // ✅ doughnut থেকে pie এ পরিবর্তন
  data: {
    labels: ["Completed", "Processing", "Pending", "Cancelled", "Returned"],
    datasets: [{
      data: [40, 30, 10, 13, 7], // ✅ শতাংশ অনুযায়ী মান
      backgroundColor: ['#00bcd4', '#42a5f5', '#ffb300', '#757575', '#8bc34a'], // ✅ ছবির মতো রঙ
      hoverBackgroundColor: ['#00acc1', '#1e88e5', '#ffa000', '#616161', '#7cb342'],
      borderColor: "#ffffff", // ✅ সাদা border দিলে clean দেখাবে
      borderWidth: 2
    }],
  },
  options: {
    maintainAspectRatio: false,
    tooltips: {
      backgroundColor: "rgb(255,255,255)",
      bodyFontColor: "#858796",
      borderColor: '#dddfeb',
      borderWidth: 1,
      xPadding: 15,
      yPadding: 15,
      displayColors: true,
      caretPadding: 10,
    },
    legend: {
      display: true,
      position: 'right', // ✅ লেবেল ডান পাশে যাবে
      labels: {
        boxWidth: 15
      }
    },
  },
});
