# from django.db import models

# from hr.models import *
# from inventory_app.models import Product
# from sales_app.models import *
# # Create your models here.

# # 3. Sales & Order Management
# class Customer(models.Model):
#     name = models.CharField(max_length=100)
#     email = models.EmailField(unique=True)
#     phone = models.CharField(max_length=20)
#     address = models.TextField()
#     created = models.DateTimeField(auto_now_add=True)

#     class Meta:
#         db_table = 'customer'

# class SalesOrder(models.Model):
#     customer = models.ForeignKey(Customer, on_delete=models.CASCADE)
#     order_date = models.DateField()
#     total_amount = models.DecimalField(max_digits=12, decimal_places=2)
#     status = models.CharField(max_length=20, choices=[('Pending', 'Pending'), ('Completed', 'Completed')], default='Pending')

#     class Meta:
#         db_table = 'sales_order'

# class SalesOrderItem(models.Model):
#     product = models.ForeignKey(Product, on_delete=models.CASCADE)
#     sales_order = models.ForeignKey(SalesOrder, on_delete=models.CASCADE, related_name='items') 
#     quantity = models.PositiveIntegerField()
#     unit_price = models.DecimalField(max_digits=10, decimal_places=2)

#     class Meta:
#         db_table = 'sales_order_item'

# class SalesInvoice(models.Model):
#     sales_order = models.ForeignKey(SalesOrder, on_delete=models.CASCADE)
#     invoice_date = models.DateField()
#     amount = models.DecimalField(max_digits=12, decimal_places=2)

#     class Meta:
#         db_table = 'sales_invoice'

# class SalesPayment(models.Model):
#     invoice = models.ForeignKey(SalesInvoice, on_delete=models.CASCADE)
#     payment_date = models.DateField()
#     amount = models.DecimalField(max_digits=12, decimal_places=2)
#     method = models.CharField(max_length=50)

#     class Meta:
#         db_table = 'sales_payment'

# class Cart(models.Model):
#     customer = models.ForeignKey(Customer, on_delete=models.CASCADE)
#     product = models.ForeignKey(Product, on_delete=models.CASCADE)
#     quantity = models.PositiveIntegerField()

#     class Meta:
#         db_table = 'cart'
#         unique_together = ('customer', 'product')

# class Wishlist(models.Model):
#     customer = models.ForeignKey(Customer, on_delete=models.CASCADE)
#     product = models.ForeignKey(Product, on_delete=models.CASCADE)

#     class Meta:
#         db_table = 'wishlist'

# class Coupon(models.Model):
#     code = models.CharField(max_length=20, unique=True)
#     discount_percent = models.PositiveIntegerField()
#     valid_from = models.DateField()
#     valid_to = models.DateField()

#     class Meta:
#         db_table = 'coupon'

# class Discount(models.Model):
#     product = models.ForeignKey(Product, on_delete=models.CASCADE)
#     discount_percent = models.PositiveIntegerField()
#     start_date = models.DateField()
#     end_date = models.DateField()

#     class Meta:
#         db_table = 'discount'


