# Generated by Django 4.2.16 on 2025-11-17 08:51

import ckeditor.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="BrandList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("brand_name", models.CharField(blank=True, max_length=60, null=True)),
                ("details", models.TextField(blank=True, null=True)),
                ("ordering", models.IntegerField(default=0)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("status", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "brand_list",
            },
        ),
        migrations.CreateModel(
            name="CategoryList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", models.TextField(blank=True)),
                ("ordering", models.IntegerField(default=0)),
                (
                    "image",
                    models.ImageField(
                        blank=True, null=True, upload_to="category_images/"
                    ),
                ),
                ("is_homepage", models.BooleanField(default=False)),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField()),
            ],
            options={
                "db_table": "category_list",
            },
        ),
        migrations.CreateModel(
            name="ColorList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("color_name", models.CharField(blank=True, max_length=60, null=True)),
                ("details", models.TextField(blank=True, null=True)),
                ("ordering", models.IntegerField(default=0)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("status", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "color_list",
            },
        ),
        migrations.CreateModel(
            name="CourierService",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "courier_name",
                    models.CharField(blank=True, max_length=60, null=True),
                ),
                ("courier_address", models.TextField(blank=True, null=True)),
                ("ordering", models.IntegerField(default=0)),
                ("status", models.BooleanField(default=1)),
            ],
            options={
                "db_table": "courier_service_list",
            },
        ),
        migrations.CreateModel(
            name="CustomerList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("customer_name", models.CharField(max_length=30)),
                ("mobile", models.CharField(max_length=15)),
                ("optional_mobile", models.CharField(blank=True, max_length=15)),
                ("email", models.CharField(blank=True, max_length=170, null=True)),
                ("username", models.CharField(blank=True, max_length=100)),
                ("password", models.CharField(max_length=100)),
                ("login_otp", models.IntegerField(blank=True, null=True)),
                ("reg_date", models.DateTimeField(auto_now_add=True)),
                ("address", models.TextField(blank=True)),
                (
                    "profile_images",
                    models.ImageField(blank=True, upload_to="images/customer_images"),
                ),
                ("is_guest", models.BooleanField(default=1)),
                (
                    "customer_level",
                    models.CharField(blank=True, max_length=55, null=True),
                ),
                (
                    "total_point",
                    models.DecimalField(decimal_places=6, default=0, max_digits=30),
                ),
                (
                    "used_point",
                    models.DecimalField(decimal_places=6, default=0, max_digits=30),
                ),
                (
                    "available_point",
                    models.DecimalField(decimal_places=6, default=0, max_digits=30),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("status", models.BooleanField(default=1)),
            ],
            options={
                "db_table": "customer_list",
            },
        ),
        migrations.CreateModel(
            name="DistrictList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("district_name_english", models.CharField(max_length=100)),
                (
                    "district_name_bangla",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("rank", models.IntegerField(default=0)),
                ("shipping_cost", models.IntegerField(default=0)),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "district_list",
            },
        ),
        migrations.CreateModel(
            name="ProductList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name_bangla", models.CharField(max_length=250, null=True)),
                (
                    "name_english",
                    models.CharField(blank=True, max_length=250, null=True),
                ),
                ("slug", models.CharField(blank=True, max_length=250, null=True)),
                ("sku_code", models.CharField(blank=True, max_length=50)),
                ("unit_price", models.DecimalField(decimal_places=2, max_digits=10)),
                (
                    "discount",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                (
                    "discount_price",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                ("discount_status", models.IntegerField(default=0)),
                ("quantity", models.IntegerField(default=0)),
                ("delivery_min_day", models.IntegerField(blank=True, null=True)),
                ("delivery_max_day", models.IntegerField(blank=True, null=True)),
                ("is_variant", models.BooleanField(default=False)),
                (
                    "stock_status",
                    models.CharField(
                        choices=[("1", "Available"), ("2", "Out of Stock")],
                        max_length=10,
                    ),
                ),
                ("short_detail", models.TextField(blank=True, null=True)),
                ("full_detail", ckeditor.fields.RichTextField(blank=True, null=True)),
                ("created", models.DateField(auto_now_add=True)),
                ("updated", models.DateField()),
                ("deleted_status", models.BooleanField(default=0)),
                (
                    "product_image",
                    models.ImageField(blank=True, null=True, upload_to="product_img/"),
                ),
                (
                    "seo_meta_title",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "seo_meta_description",
                    ckeditor.fields.RichTextField(blank=True, null=True),
                ),
                (
                    "seo_focus_keyword",
                    models.TextField(blank=True, max_length=100, null=True),
                ),
                (
                    "seo_og_image",
                    models.ImageField(
                        blank=True, null=True, upload_to="product/og_images/"
                    ),
                ),
                ("total_reviews", models.IntegerField(default=0)),
                ("total_sales", models.IntegerField(default=0)),
                (
                    "average_rating",
                    models.DecimalField(decimal_places=2, default=0.0, max_digits=3),
                ),
                (
                    "brand",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.brandlist",
                    ),
                ),
            ],
            options={
                "db_table": "product_list",
            },
        ),
        migrations.CreateModel(
            name="SalesOrder",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("order_number", models.IntegerField(default=0)),
                ("shipping_person_name", models.CharField(max_length=180)),
                ("shipping_mobile", models.CharField(max_length=15)),
                ("shipping_email", models.EmailField(blank=True, max_length=150)),
                ("shipping_address", models.CharField(max_length=20000)),
                ("total_amount", models.IntegerField(default=0)),
                ("vat_amount", models.IntegerField(default=0)),
                ("discount_amount", models.IntegerField(default=0)),
                ("less_amount", models.IntegerField(default=0)),
                ("due_amount", models.IntegerField(default=0)),
                ("shipping_charge", models.IntegerField(default=0)),
                ("service_charge", models.IntegerField(default=0)),
                ("service_code", models.IntegerField(default=0)),
                ("grand_total", models.IntegerField(default=0)),
                (
                    "payment_method",
                    models.CharField(
                        choices=[
                            ("cod", "COD"),
                            ("bkash", "Bkash"),
                            ("rocket", "Rocket"),
                            ("nagad", "Nagad"),
                            ("aamarpay", "AamarPay"),
                        ],
                        default=1,
                        max_length=20,
                    ),
                ),
                (
                    "payment_status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("paid", "Paid"),
                            ("refund", "Refund"),
                        ],
                        default=1,
                        max_length=20,
                    ),
                ),
                (
                    "order_status",
                    models.CharField(
                        choices=[
                            ("1", "Pending"),
                            ("2", "Confirmed"),
                            ("3", "Packed"),
                            ("4", "Shipping"),
                            ("5", "Delivered"),
                            ("6", "Returned"),
                            ("7", "Canceled"),
                            ("8", "Hold"),
                        ],
                        default=1,
                        max_length=20,
                    ),
                ),
                ("session_key", models.CharField(max_length=230)),
                ("order_date", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(null=True)),
                ("order_remarks", models.TextField(blank=True, null=True)),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.CustomerList",
                    ),
                ),
                (
                    "delivery_method",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.courierservice",
                    ),
                ),
                (
                    "district",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.districtlist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Sales Order",
                "verbose_name_plural": "Sales Orders",
                "db_table": "sales_order",
            },
        ),
        migrations.CreateModel(
            name="SizeList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("size_name", models.CharField(blank=True, max_length=60, null=True)),
                ("short_code", models.CharField(blank=True, max_length=10, null=True)),
                ("ordering", models.IntegerField(default=0)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("status", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "size_list",
            },
        ),
        migrations.CreateModel(
            name="UpozillaList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=230)),
                ("rank", models.IntegerField(default=0)),
                ("status", models.BooleanField(default=1)),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "district",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.districtlist",
                    ),
                ),
            ],
            options={
                "db_table": "upozilla_list",
            },
        ),
        migrations.CreateModel(
            name="SalesOrderDetails",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("unit_price", models.DecimalField(decimal_places=2, max_digits=10)),
                (
                    "discount",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                (
                    "discount_price",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                ("quantity", models.IntegerField(default=1)),
                (
                    "total_price",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                ("remarks", models.TextField(blank=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(blank=True, null=True)),
                ("status", models.BooleanField(default=1)),
                (
                    "color",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.colorlist",
                    ),
                ),
                (
                    "order_no",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.salesorder",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.productlist",
                    ),
                ),
                (
                    "size",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.sizelist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Sales Order Detail",
                "verbose_name_plural": "Sales Order Details",
                "db_table": "sales_order_details",
            },
        ),
        migrations.AddField(
            model_name="salesorder",
            name="upozilla",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                to="inventory_app.upozillalist",
            ),
        ),
        migrations.CreateModel(
            name="RecentViewProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("session_key", models.CharField(max_length=250)),
                ("view_date", models.DateTimeField(auto_now_add=True)),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.productlist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Recent View Product",
                "verbose_name_plural": "Recent View Products",
                "db_table": "recent_view_products",
            },
        ),
        migrations.CreateModel(
            name="ProductWiseSize",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("unit_price", models.DecimalField(decimal_places=2, max_digits=10)),
                ("discount", models.DecimalField(decimal_places=2, max_digits=10)),
                (
                    "discount_price",
                    models.DecimalField(decimal_places=2, max_digits=10),
                ),
                ("quantity", models.PositiveIntegerField(default=0)),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.productlist",
                    ),
                ),
                (
                    "size",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.sizelist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Wise Size",
                "verbose_name_plural": "Product Wise Sizes",
                "db_table": "product_wise_size",
            },
        ),
        migrations.CreateModel(
            name="ProductWiseColor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "color",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.colorlist",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.productlist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Wise Color",
                "verbose_name_plural": "Product Wise Colors",
                "db_table": "product_wise_color",
            },
        ),
        migrations.CreateModel(
            name="ProductWiseCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "category",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.categorylist",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="inventory_app.productlist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Wise Category",
                "verbose_name_plural": "Product Wise Categories",
                "db_table": "product_wise_category",
            },
        ),
        migrations.CreateModel(
            name="ProductReview",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("email", models.EmailField(max_length=254)),
                ("rating", models.IntegerField()),
                ("review", models.TextField()),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.productlist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Review",
                "verbose_name_plural": "Product Reviews",
                "db_table": "product_review",
            },
        ),
        migrations.CreateModel(
            name="ProductImage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("image", models.ImageField(upload_to="product_images/")),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.productlist",
                    ),
                ),
            ],
            options={
                "db_table": "product_image",
            },
        ),
        migrations.AddField(
            model_name="CustomerList",
            name="district",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                to="inventory_app.districtlist",
            ),
        ),
        migrations.AddField(
            model_name="CustomerList",
            name="upozilla",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                to="inventory_app.upozillalist",
            ),
        ),
    ]
