# Generated by Django 4.2.16 on 2025-11-17 08:51

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("inventory_app", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="BusinessProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("business_name", models.CharField(max_length=250)),
                ("tagline", models.CharField(blank=True, max_length=250, null=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("email", models.EmailField(blank=True, max_length=150, null=True)),
                ("mobile", models.CharField(blank=True, max_length=20, null=True)),
                (
                    "mobile_optional",
                    models.CharField(blank=True, max_length=20, null=True),
                ),
                ("address", models.TextField(blank=True, null=True)),
                ("map_embed_code", models.TextField(blank=True, null=True)),
                (
                    "logo",
                    models.ImageField(
                        blank=True, null=True, upload_to="business/logo/"
                    ),
                ),
                (
                    "favicon",
                    models.ImageField(
                        blank=True, null=True, upload_to="business/favicon/"
                    ),
                ),
                ("shipping_cost_inside", models.IntegerField(default=0)),
                ("shipping_cost_outside", models.IntegerField(default=0)),
                ("facebook", models.URLField(blank=True, max_length=250, null=True)),
                ("instagram", models.URLField(blank=True, max_length=250, null=True)),
                ("twitter", models.URLField(blank=True, max_length=250, null=True)),
                ("linkedin", models.URLField(blank=True, max_length=250, null=True)),
                ("youtube", models.URLField(blank=True, max_length=250, null=True)),
                (
                    "seo_meta_title",
                    models.CharField(blank=True, max_length=70, null=True),
                ),
                (
                    "seo_meta_description",
                    models.CharField(blank=True, max_length=160, null=True),
                ),
                (
                    "seo_keywords",
                    models.CharField(blank=True, max_length=250, null=True),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Business Profile",
                "verbose_name_plural": "Business Profiles",
                "db_table": "business_profile",
            },
        ),
        migrations.CreateModel(
            name="Department",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("rank", models.IntegerField()),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "department_list",
            },
        ),
        migrations.CreateModel(
            name="Designation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("rank", models.IntegerField()),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "designation_list",
            },
        ),
        migrations.CreateModel(
            name="Employee",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("employee_id", models.CharField(max_length=20, unique=True)),
                ("password", models.CharField(max_length=128)),
                ("full_name", models.CharField(max_length=150)),
                ("email", models.EmailField(max_length=254, unique=True)),
                ("phone", models.CharField(blank=True, max_length=20, null=True)),
                ("address", models.TextField(blank=True, null=True)),
                ("join_date", models.DateField()),
                ("salary_basic", models.DecimalField(decimal_places=2, max_digits=10)),
                ("salary_gross", models.DecimalField(decimal_places=2, max_digits=10)),
                ("national_id", models.CharField(blank=True, max_length=30, null=True)),
                (
                    "photo",
                    models.ImageField(
                        blank=True, null=True, upload_to="employee_photos/"
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("is_delete", models.BooleanField(default=False)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "department",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="employees",
                        to="hr.department",
                    ),
                ),
                (
                    "designation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="employees",
                        to="hr.designation",
                    ),
                ),
            ],
            options={
                "db_table": "employee_list",
            },
        ),
        migrations.CreateModel(
            name="Module",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("rank", models.IntegerField(default=1)),
                ("icon", models.CharField(blank=True, max_length=100, null=True)),
                ("color", models.CharField(blank=True, max_length=100, null=True)),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "module_list",
            },
        ),
        migrations.CreateModel(
            name="ModuleMenu",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("rank", models.IntegerField(default=1)),
                ("menu_url", models.CharField(blank=True, max_length=100, null=True)),
                ("icon", models.CharField(blank=True, max_length=100, null=True)),
                ("color", models.CharField(blank=True, max_length=100, null=True)),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "module",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="menus",
                        to="hr.module",
                    ),
                ),
            ],
            options={
                "db_table": "module_menu_list",
            },
        ),
        migrations.CreateModel(
            name="SliderList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(blank=True, max_length=200, null=True)),
                ("subtitle", models.CharField(blank=True, max_length=250, null=True)),
                ("image", models.ImageField(upload_to="sliders/")),
                (
                    "ordering",
                    models.PositiveIntegerField(
                        default=0, help_text="Order of the slider"
                    ),
                ),
                ("status", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Slider",
                "verbose_name_plural": "Sliders",
                "db_table": "slider_list",
            },
        ),
        migrations.CreateModel(
            name="UserAccessControl",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("can_create", models.BooleanField(default=False)),
                ("can_read", models.BooleanField(default=False)),
                ("can_update", models.BooleanField(default=False)),
                ("can_delete", models.BooleanField(default=False)),
                (
                    "created_by",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="created_accesses",
                        to="hr.employee",
                    ),
                ),
                (
                    "employee",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="accesses",
                        to="hr.employee",
                    ),
                ),
                (
                    "menu",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="access_controls",
                        to="hr.modulemenu",
                    ),
                ),
                (
                    "module",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="access_controls",
                        to="hr.module",
                    ),
                ),
            ],
            options={
                "db_table": "user_access_control",
            },
        ),
        migrations.CreateModel(
            name="Payroll",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("month", models.CharField(max_length=20)),
                ("salary", models.DecimalField(decimal_places=2, max_digits=10)),
                ("paid_on", models.DateField()),
                (
                    "employee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="hr.employee"
                    ),
                ),
            ],
            options={
                "db_table": "payroll",
            },
        ),
        migrations.CreateModel(
            name="LeaveRequest",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("from_date", models.DateField()),
                ("to_date", models.DateField()),
                ("reason", models.TextField()),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("Pending", "Pending"),
                            ("Approved", "Approved"),
                            ("Rejected", "Rejected"),
                        ],
                        default="Pending",
                        max_length=20,
                    ),
                ),
                (
                    "employee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="hr.employee"
                    ),
                ),
            ],
            options={
                "db_table": "leave_request",
            },
        ),
        migrations.CreateModel(
            name="Attendance",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date", models.DateField()),
                (
                    "status",
                    models.CharField(
                        choices=[("Present", "Present"), ("Absent", "Absent")],
                        max_length=10,
                    ),
                ),
                (
                    "employee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="hr.employee"
                    ),
                ),
            ],
            options={
                "db_table": "attendance",
            },
        ),
        migrations.CreateModel(
            name="AddToCart",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("session_key", models.CharField(blank=True, max_length=50, null=True)),
                ("quantity", models.PositiveIntegerField(default=1)),
                (
                    "unit_price",
                    models.DecimalField(decimal_places=2, default=0.0, max_digits=12),
                ),
                (
                    "discount_price",
                    models.DecimalField(decimal_places=2, default=0.0, max_digits=12),
                ),
                (
                    "discount",
                    models.DecimalField(decimal_places=2, default=0.0, max_digits=12),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "color",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.colorlist",
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.CustomerList",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.productlist",
                    ),
                ),
                (
                    "size",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="inventory_app.sizelist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Add To Cart",
                "verbose_name_plural": "Add To Carts",
                "db_table": "add_to_cart",
                "unique_together": {("session_key", "product")},
            },
        ),
    ]
