from .models import Employee, UserAccessControl

def sidebar_menus(request):
    employee_id = request.session.get('employee_id')
    
    # Only load menus if employee is logged in
    if employee_id:
        try:
            employee = Employee.objects.get(employee_id=employee_id, is_active=True, is_delete=False)
            
            # Get access controls with can_read=True
            access_controls = UserAccessControl.objects.filter(
                employee=employee,
                can_read=True,
                menu__status=True,
                module__status=True
            ).select_related('menu', 'module').order_by('module__rank', 'menu__rank')

            # Group by module
            module_menus = {}
            for access in access_controls:
                module = access.module
                menu = access.menu

                if module not in module_menus:
                    module_menus[module] = []

                module_menus[module].append(menu)

            return {'sidebar_module_menus': module_menus}
        
        except Employee.DoesNotExist:
            return {}

    return {}
