from django.contrib import admin
from django.urls import path, include 
from django.conf import settings
from django.conf.urls.static import static

urlpatterns = [
    path('admin/', admin.site.urls), 
 
    path('', include('ecom_app.urls')),

    path('hr/', include('hr.urls')),

    # Modules
    path('inventory/', include('inventory_app.urls')),
    
    path('reports/', include('reports_app.urls')),
    path('settings/', include('settings_app.urls')),

    # path('sales/', include('sales.urls')),
    # path('accounts/', include('accounts.urls')),
    # path('hr/', include('hr.urls')),
    # path('cms/', include('cms.urls')),
    # path('support/', include('support.urls')),
    # path('delivery/', include('delivery.urls')),
    # path('marketing/', include('marketing.urls')),
    # path('config/', include('configuration.urls')),
    # path('users/', include('users.urls')),
]
 
if settings.DEBUG:
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
